/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.world.biomes;

import java.util.Random;
import net.minecraft.class_1936;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_6908;
import paulevs.betternether.BlocksHelper;
import paulevs.betternether.world.NetherBiome;
import paulevs.betternether.world.NetherBiomeConfig;
import paulevs.betternether.world.structures.StructureType;
import paulevs.betternether.world.structures.decorations.StructureCrystal;
import paulevs.betternether.world.structures.decorations.StructureGeyser;
import paulevs.betternether.world.structures.plants.StructureGoldenVine;
import paulevs.betternether.world.structures.plants.StructureMagmaFlower;
import ru.bclib.api.biomes.BCLBiomeBuilder;
import ru.bclib.world.biomes.BCLBiomeSettings;

public class NetherMagmaLand
extends NetherBiome {
    private static final boolean[] MASK = new boolean[]{false, true, false, false, false, false, false, true, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, true, false, false, false, false, true, true, false, false, true, true, true, false, false, false, true, true, false, false, false, true, false, false, true, true, true, false, false, true, true, true, true, false, true, true, true, true, false, false, false, true, true, false, false, true, true, true, false, false, false, false, false, true, false, false, false, false, true, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, true, true, true, true, false, false, false, true, true, true, true, false, false, false, true, true, false, true, true, true, true, true, true, true, false, false, true, true, false, true, true, false, false, false, true, false, false, true, false, false, false, false, false, true, true, true, false, false, false, false, true, false, false, true, false, false, false, false, false, false, true, false, false, false, false, true, false, false, false, true, true, false, false, false, false, false, true, false, false, false, false, true, false, true, false, false, false, true, false, false, false, false, true, false, false, false, false, true, false, true, true, false, false, true, false, false, false, true, true, true, true, true, true, false, true, false, true, true, true, true, true, true, true, false, false, false, false, true, false, false, false, false, true, true, false, false, false, true, false, false, false, false, false, true, true, false, false};

    public NetherMagmaLand(class_2960 biomeID, class_1959 biome, BCLBiomeSettings settings) {
        super(biomeID, biome, settings);
    }

    @Override
    protected void onInit() {
        this.addStructure("geyser", new StructureGeyser(), StructureType.FLOOR, 0.1f, false);
        this.addStructure("obsidian_crystals", new StructureCrystal(), StructureType.FLOOR, 0.04f, true);
        this.addStructure("magma_flower", new StructureMagmaFlower(), StructureType.FLOOR, 0.4f, false);
        this.addStructure("golden_vine", new StructureGoldenVine(), StructureType.CEIL, 0.2f, true);
    }

    @Override
    public void genSurfColumn(class_1936 world, class_2338 pos, Random random) {
        if (this.isMask(pos.method_10263(), pos.method_10260())) {
            class_2338.class_2339 POS = new class_2338.class_2339();
            POS.method_10101((class_2382)pos);
            boolean magma = true;
            if (random.nextInt(4) == 0 && this.validWall(world, POS.method_10074()) && this.validWall(world, POS.method_10095()) && this.validWall(world, POS.method_10072()) && this.validWall(world, POS.method_10078()) && this.validWall(world, POS.method_10067())) {
                BlocksHelper.setWithoutUpdate(world, (class_2338)POS, class_2246.field_10164.method_9564());
                magma = false;
            }
            if (magma) {
                for (int y = 0; y < random.nextInt(3) + 1; ++y) {
                    POS.method_33098(pos.method_10264() - y);
                    if (!BlocksHelper.isNetherGround(world.method_8320((class_2338)POS))) continue;
                    BlocksHelper.setWithoutUpdate(world, (class_2338)POS, class_2246.field_10092.method_9564());
                }
            }
        } else {
            super.genSurfColumn(world, pos, random);
        }
    }

    protected boolean validWall(class_1936 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        return BlocksHelper.isLava(state) || BlocksHelper.isNetherGroundMagma(state);
    }

    protected boolean isMask(int x, int z) {
        return MASK[(x &= 0xF) << 4 | (z &= 0xF)];
    }

    public static class Config
    extends NetherBiomeConfig {
        public Config(String name) {
            super(name);
        }

        @Override
        protected void addCustomBuildData(BCLBiomeBuilder builder) {
            builder.fogColor(248, 158, 68).loop(class_3417.field_22455).additions(class_3417.field_22454).mood(class_3417.field_22456).structure(class_6908.field_36503);
        }

        @Override
        public BCLBiomeBuilder.BiomeSupplier<NetherBiome> getSupplier() {
            return NetherMagmaLand::new;
        }
    }
}

